/*
 * Decompiled with CFR 0.152.
 */
package standalone;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import standalone.Scanner_3;
import standalone.chemicalShift;
import standalone.strReader_5;

public class PANAV
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1L;
    protected JSplitPane m_sp;
    JTextArea Ref_mess = new JTextArea();
    JScrollPane Ref_jp = new JScrollPane(this.Ref_mess);
    JTextPane Val_mess = new JTextPane();
    JScrollPane Val_jp = new JScrollPane(this.Val_mess);
    Object[][] atFirst;
    Object[][] caliberated;
    File returnfile;
    double allow = 0.1;
    int[] res_len = new int[]{3, 4, 5, 6};
    strReader_5 strreader;
    GridBagConstraints constraints = new GridBagConstraints();
    chemicalShift chemical;
    JTable table;
    JScrollPane scroll;
    chemicalShift chemicalcal;
    JTable tablecal;
    JScrollPane scrollcal;
    JTabbedPane tables = new JTabbedPane();
    Border forTables = BorderFactory.createEtchedBorder();
    JMenuBar menu = new JMenuBar();
    JMenu filelist = new JMenu("File");
    JMenuItem open = new JMenuItem("Read .str File");
    JMenuItem open2 = new JMenuItem("Read shift_X File");
    JMenuItem open3 = new JMenuItem("Read shift_Y File");
    JMenuItem save = new JMenuItem("Save Output");
    JMenu about = new JMenu("About");
    JMenu exit = new JMenu("Exit");

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("Read .str File") || string.equals("Read shift_X File") || string.equals("Read shift_Y File")) {
            this.loadStrFile();
            if (string.equals("Read .str File")) {
                this.strreader = new strReader_5(this.returnfile, "str");
            } else if (string.equals("Read shift_X File")) {
                this.strreader = new strReader_5(this.returnfile, "shiftX_table");
            } else if (string.equals("Read shift_Y File")) {
                this.strreader = new strReader_5(this.returnfile, "shiftY");
            }
            this.atFirst = this.strreader.getDisplayElements();
            this.addTable();
            this.caliberated = this.strreader.getCal_DisplayElements();
            if (this.strreader.need_ref_cal) {
                this.addCalTable();
                this.Ref_mess.setText("Detected reference offsets \n" + this.strreader.ref_shift + "\n\n" + this.strreader.get_D_S_shift());
            } else {
                this.Ref_mess.setText("no reference offsets required\n\n" + this.strreader.get_D_S_shift());
            }
            this.add_Val();
        }
        if (string.equals("Save Output")) {
            try {
                FileWriter fileWriter = new FileWriter("../" + this.returnfile.getName() + "_output.txt");
                try {
                    Document document = this.Val_mess.getDocument();
                    fileWriter.write(document.getText(0, document.getLength()) + this.Ref_mess.getText());
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                fileWriter.close();
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            JOptionPane.showMessageDialog(this, "Output saved as ../" + this.returnfile.getName() + "_output.txt", "File Saved!", 1);
        }
    }

    void addGB(Component component, int n, int n2, double d, double d2) {
        this.constraints.gridx = n;
        this.constraints.gridy = n2;
        this.constraints.weightx = d;
        this.constraints.weighty = d2;
        this.add(component, this.constraints);
    }

    public void addTable() {
        this.chemical = new chemicalShift(this.atFirst);
        this.table = new JTable(this.chemical);
        this.scroll = new JScrollPane(this.table);
        this.tables.addTab(this.returnfile.getName(), this.scroll);
        this.table.repaint();
    }

    public void addCalTable() {
        this.chemicalcal = new chemicalShift(this.caliberated);
        this.tablecal = new JTable(this.chemicalcal);
        this.scrollcal = new JScrollPane(this.tablecal);
        this.tables.addTab("No_deviant_Ref_calibrated", this.scrollcal);
        this.table.repaint();
    }

    public void add_Val() {
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet, Color.red);
        StyleConstants.setBold(simpleAttributeSet, true);
        SimpleAttributeSet simpleAttributeSet2 = new SimpleAttributeSet();
        StyleConstants.setForeground(simpleAttributeSet2, Color.blue);
        SimpleAttributeSet simpleAttributeSet3 = new SimpleAttributeSet();
        StyleConstants.setItalic(simpleAttributeSet3, true);
        StyleConstants.setForeground(simpleAttributeSet3, Color.orange);
        this.Val_mess.setFont(new Font("Serif", 0, 24));
        Document document = this.Val_mess.getDocument();
        try {
            document.remove(0, document.getLength());
            document.insertString(document.getLength(), this.returnfile.getName() + "\n", simpleAttributeSet2);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        this.Val_mess.setFont(new Font("Serif", 0, 12));
        String string = this.strreader.getSequence();
        int[] nArray = this.strreader.getSequenceLine();
        Double[][] doubleArray = this.strreader.getSixtyCal();
        for (int i = 0; i < this.res_len.length; ++i) {
            boolean[] blArray = this.strreader.getscannableList(this.res_len[i]);
            Scanner_3 scanner_3 = new Scanner_3(string, nArray, doubleArray, this.res_len[i], this.allow, blArray);
            int[] nArray2 = scanner_3.get_s_pos();
            String[] stringArray = scanner_3.get_Score();
            String[] stringArray2 = scanner_3.get_o_prob_nor();
            try {
                int n;
                this.Val_mess.setFont(new Font("Serif", 0, 24));
                document.insertString(document.getLength(), "\n" + Integer.toString(this.res_len[i]) + "-Resdue Scan: \n\n", simpleAttributeSet2);
                this.Val_mess.setFont(new Font("Serif", 0, 12));
                boolean[] blArray2 = new boolean[nArray2.length + this.res_len[i]];
                for (n = 0; n < blArray2.length; ++n) {
                    blArray2[n] = true;
                }
                for (n = 0; n < blArray2.length - this.res_len[i]; ++n) {
                    for (int j = 0; j < this.res_len[i]; ++j) {
                        if (nArray2[n] <= 0) continue;
                        blArray2[n + j] = false;
                    }
                }
                for (n = 0; n < blArray2.length; ++n) {
                    try {
                        if (blArray2[n]) {
                            document.insertString(document.getLength(), string.substring(n, n + 1), simpleAttributeSet2);
                        } else {
                            document.insertString(document.getLength(), string.substring(n, n + 1), simpleAttributeSet);
                        }
                        if (!Integer.toString(n + 1).endsWith("0") || n <= 0) continue;
                        document.insertString(document.getLength(), "  ", simpleAttributeSet2);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                document.insertString(document.getLength(), "\n\nOriginal Assigment and Probability vs Suggested Assignment and Probability \n\n", simpleAttributeSet2);
                document.insertString(document.getLength(), scanner_3.get_message(), simpleAttributeSet2);
                document.insertString(document.getLength(), "\n", simpleAttributeSet2);
                document.insertString(document.getLength(), "# of selected frags: " + stringArray[0] + ";   # of confirmed frags: " + stringArray[1] + "; CONA Score:  " + stringArray[2] + "\n", simpleAttributeSet2);
                continue;
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    public void loadStrFile() {
        JFileChooser jFileChooser = new JFileChooser();
        int n = jFileChooser.showOpenDialog(this);
        if (n == 1) {
            return;
        }
        try {
            this.returnfile = jFileChooser.getSelectedFile();
        }
        catch (Exception exception) {
            System.out.println("Problem reading file");
        }
    }

    private String get_validation_mesg() {
        String string = "";
        string = string + this.returnfile.getName() + "\n";
        String string2 = this.strreader.getSequence();
        int[] nArray = this.strreader.getSequenceLine();
        Double[][] doubleArray = this.strreader.getSixtyCal();
        for (int i = 0; i < this.res_len.length; ++i) {
            int n;
            boolean[] blArray = this.strreader.getscannableList(this.res_len[i]);
            Scanner_3 scanner_3 = new Scanner_3(string2, nArray, doubleArray, this.res_len[i], this.allow, blArray);
            int[] nArray2 = scanner_3.get_s_pos();
            String[] stringArray = scanner_3.get_Score();
            String[] stringArray2 = scanner_3.get_o_prob_nor();
            string = string + "\n" + this.res_len[i] + "-Residue Scan: \n\n";
            boolean[] blArray2 = new boolean[nArray2.length + this.res_len[i]];
            for (n = 0; n < blArray2.length; ++n) {
                blArray2[n] = true;
            }
            for (n = 0; n < blArray2.length - this.res_len[i]; ++n) {
                for (int j = 0; j < this.res_len[i]; ++j) {
                    if (nArray2[n] <= 0) continue;
                    blArray2[n + j] = false;
                }
            }
            for (n = 0; n < blArray2.length - 1; ++n) {
                string = blArray2[n] ? string + string2.substring(n, n + 1) : string + string2.substring(n, n + 1);
                if (!Integer.toString(n + 1).endsWith("0") || n <= 0) continue;
                string = string + "  ";
            }
            string = string + "\n\nOriginal Assigment and Probability vs Suggested Assignment and Probability \n\n";
            string = string + scanner_3.get_message() + "\n";
            string = string + "# of selected frags: " + stringArray[0] + ";   # of confirmed frags: " + stringArray[1] + "; CONA Score:  " + stringArray[2] + "\n";
        }
        return string;
    }

    public PANAV(String string, String string2, String string3) {
        this.returnfile = new File(string2);
        this.strreader = new strReader_5(this.returnfile, string);
        this.caliberated = this.strreader.getCal_DisplayElements();
        String string4 = "";
        string4 = this.strreader.need_ref_cal ? "Detected reference offsets \n" + this.strreader.ref_shift + "\n\n" + this.strreader.get_D_S_shift() : "no reference offsets required\n\n" + this.strreader.get_D_S_shift();
        this.write_calib_seq(this.caliberated, string3);
        String string5 = this.get_validation_mesg();
        try {
            FileWriter fileWriter = new FileWriter(string3);
            fileWriter.write(string5 + "\n\n" + string4);
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        System.exit(0);
    }

    private void write_calib_seq(Object[][] objectArray, String string) {
        String[] stringArray = new String[]{"Seq", "C", "CA", "CB", "N", "H", "HA", "B-prob", "C-prob", "H-prob", "SecStr"};
        String string2 = String.format("%6s\t%6s\t%6s\t%6s\t%6s\t%6s\t%6s\t%6s\t%6s\t%6s\t%6s\n", stringArray);
        try {
            FileWriter fileWriter = new FileWriter(string + "_calibrated");
            fileWriter.write(string2);
            for (int i = 0; i < objectArray.length; ++i) {
                fileWriter.write(String.format("%6s\t%6s\t%6s\t%6s\t%6s\t%6s\t%6s\t%6s\t%6s\t%6s\t%6s\n", objectArray[i]));
            }
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public PANAV() {
        this.tables.setBorder(BorderFactory.createTitledBorder(this.forTables, "CSI and Sec Structure", 1, 2));
        this.setLayout(new GridBagLayout());
        this.constraints.weightx = 1.0;
        this.constraints.weighty = 1.0;
        this.constraints.fill = 1;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.setBorder(new TitledBorder(new EtchedBorder(50), "Reference offsets and Deviant shifts"));
        jPanel.add(this.Ref_jp);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel2.setBorder(new TitledBorder(new EtchedBorder(50), "Validatation"));
        jPanel2.add(this.Val_jp);
        this.m_sp = new JSplitPane(0, this.tables, jPanel2);
        this.m_sp.setDividerLocation(150);
        this.m_sp.setDividerSize(8);
        this.m_sp.setContinuousLayout(false);
        this.m_sp.setOneTouchExpandable(true);
        this.addGB(this.m_sp, 0, 0, 1.0, 16.0);
        this.addGB(jPanel, 0, 1, 1.0, 4.0);
        this.menu.add(this.filelist);
        this.filelist.add(this.open);
        this.filelist.add(this.open2);
        this.filelist.add(this.open3);
        this.filelist.add(this.save);
        this.open.addActionListener(this);
        this.open2.addActionListener(this);
        this.open3.addActionListener(this);
        this.save.addActionListener(this);
        this.menu.add(this.about);
        this.menu.add(this.exit);
        this.setJMenuBar(this.menu);
    }

    public static void main(String[] stringArray) {
        if (stringArray.length == 3) {
            new PANAV(stringArray[0], stringArray[1], stringArray[2]);
        } else {
            PANAV pANAV = new PANAV();
            pANAV.setVisible(true);
            pANAV.setSize(900, 600);
            pANAV.setDefaultCloseOperation(3);
        }
    }
}

